#include "ControlCommandManager.h"
#include "CreateEntityCommand.h"
#include "SetInitializationCommand.h"
#include "SetTimeStepCommand.h"
#include "SetStepModeCommand.h"
#include "SetStepFlagCommand.h"
#include "SetSyncModeCommand.h"
#include "SetSyncWaitCommand.h"
#include "SetAutoAdjustModeCommand.h"
#include "SetWorldGravityCommand.h"
#include "SetWorldHardnessCommand.h"
#include "SetWorldBouncinessCommand.h"
#include "SynchronizeCommand.h"
#include "RegisterMaterialsInteractionsCommand.h"
#include "SaveToFileCommand.h"
#include "LoadFromFileCommand.h"
#include "SetStepsPerIterationCommand.h"
#include "SetFastModeCommand.h"

namespace SimulationEngine
{


ControlCommandManager *ControlCommandManager::instance = 0;

ControlCommandManager::ControlCommandManager()
{
	commands.push_back(new CreateEntityCommand());
	commands.push_back(new SetInitializationCommand());
	commands.push_back(new SetTimeStepCommand());
	commands.push_back(new SetStepModeCommand());
	commands.push_back(new SetSyncModeCommand());
	commands.push_back(new SetSyncWaitCommand());
	commands.push_back(new SetStepFlagCommand());
	commands.push_back(new SynchronizeCommand());
	commands.push_back(new SetWorldHardnessCommand());
	commands.push_back(new SetWorldGravityCommand());
	commands.push_back(new SetWorldBouncinessCommand());
	commands.push_back(new RegisterMaterialsInteractionsCommand());
	commands.push_back(new SaveToFileCommand());
	commands.push_back(new LoadFromFileCommand());
	commands.push_back(new SetStepsPerIterationCommand());
	commands.push_back(new SetFastModeCommand());
	commands.push_back(new SetAutoAdjustModeCommand());
}

void ControlCommandManager::FreeResources()
{
	std::list<ICommand *>::iterator iter;
	iter = commands.begin();
	while (iter!=commands.end())
	{
		ICommand *todestroy = (*iter);
		delete todestroy;
		iter++;
	}
	commands.clear();
}

ControlCommandManager *ControlCommandManager::GetInstance()
{
	if (instance==0)
		instance =  new ControlCommandManager();
	return instance;
}

list<DataParameter*> ControlCommandManager::ExecuteControlCommand(string commandkey, list<DataParameter*> data)
{
	std::list<ICommand *>::iterator iter;
	list<DataParameter*> returnlist;
	bool found = false;
	ICommand *toexecute=0;
	iter = commands.begin();
	while (!found && iter!=commands.end())
	{
		ICommand *cmd = (*iter);

		if (strcmp(commandkey.data(), cmd->GetCommandKey().data())== 0)
		{
			toexecute = (*iter);
			found = true;
		}
		else
			iter++;
	}
	if (found ==true)
		returnlist = toexecute->execute(data);
	return returnlist;
		
}

}

